/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.explorer.internal.ui;

import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.PlatformUtil;
import com.aptana.explorer.ExplorerPlugin;
import com.aptana.explorer.internal.ui.GitProjectView;
import com.aptana.explorer.internal.ui.Messages;
import com.aptana.explorer.ui.filter.AbstractResourceBasedViewerFilter;
import com.aptana.explorer.ui.filter.PathFilter;
import com.aptana.ui.util.UIUtils;
import com.aptana.ui.widgets.SearchComposite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.progress.WorkbenchJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringProjectView
extends GitProjectView {
    private static final String ELEMENT_PRIORITY = "priority";
    private static final String ELEMENT_CLASS = "class";
    private static final String ELEMENT_NATURE = "nature";
    private static final String FILTERS_EXT_PT_ID = "filters";
    private static final String ELEMENT_FILTER = "filter";
    private static final String TAG_SELECTION = "selection";
    private static final String TAG_EXPANDED = "expanded";
    private static final String TAG_ELEMENT = "element";
    private static final String TAG_PATH = "path";
    private static final String TAG_PROJECT = "project";
    private static final String TAG_FILTER = "filter";
    private static final String KEY_NAME = "name";
    private static final long SOFT_MAX_EXPAND_TIME = 200L;
    private IResource currentFilter = null;
    private boolean fFilenameSearchMode;
    private AbstractResourceBasedViewerFilter patternFilter;
    private WorkbenchJob refreshJob;
    protected TreeItem hoveredItem;
    protected int lastDrawnX;
    protected Object[] fExpandedElements;
    private Image eyeball;
    private Composite customComposite;
    private IResourceChangeListener fResourceListener;
    private Map<IProject, List<String>> projectExpansions = new HashMap<IProject, List<String>>();
    private Map<IProject, List<String>> projectSelections = new HashMap<IProject, List<String>>();
    private Map<IProject, String> projectFilters = new HashMap<IProject, String>();
    private ArrayList<IConfigurationElement> fgElements;
    private PathFilter filenameFilter;
    private boolean filterViaSearch;
    private SearchComposite search;

    @Override
    public void createPartControl(Composite aParent) {
        this.customComposite = new Composite(aParent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.customComposite.setLayout((Layout)gridLayout);
        super.createPartControl(this.customComposite);
        this.createRefreshJob();
        this.addFocusHover();
        this.addResourceListener();
    }

    @Override
    public void init(IViewSite aSite, IMemento aMemento) throws PartInitException {
        super.init(aSite, aMemento);
        this.loadMementoCache();
        this.eyeball = ExplorerPlugin.getImage("icons/full/obj16/eye.png");
    }

    protected void loadMementoCache() {
        IMemento[] projectMementoes;
        if (this.memento == null) {
            return;
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IMemento[] iMementoArray = projectMementoes = this.memento.getChildren(TAG_PROJECT);
        int n = projectMementoes.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento projMemento = iMementoArray[n2];
            String projectName = projMemento.getString(KEY_NAME);
            IProject project = workspaceRoot.getProject(projectName);
            if (project != null && project.isAccessible()) {
                ArrayList<String> expanded = new ArrayList<String>();
                IMemento childMem = projMemento.getChild(TAG_EXPANDED);
                if (childMem != null) {
                    IMemento[] elementMem = childMem.getChildren(TAG_ELEMENT);
                    int i = 0;
                    while (i < elementMem.length) {
                        expanded.add(elementMem[i].getString(TAG_PATH));
                        ++i;
                    }
                }
                ArrayList<String> selected = new ArrayList<String>();
                childMem = projMemento.getChild(TAG_SELECTION);
                if (childMem != null) {
                    IMemento[] elementMem = childMem.getChildren(TAG_ELEMENT);
                    int i = 0;
                    while (i < elementMem.length) {
                        selected.add(elementMem[i].getString(TAG_PATH));
                        ++i;
                    }
                }
                this.projectExpansions.put(project, expanded);
                this.projectSelections.put(project, selected);
                childMem = projMemento.getChild("filter");
                if (childMem != null) {
                    this.projectFilters.put(project, childMem.getString(TAG_PATH));
                }
            }
            ++n2;
        }
    }

    protected void updateProjectMementoCache(IProject project) {
        Object[] selectedElements;
        CommonViewer viewer = this.getCommonViewer();
        if (viewer == null || project == null) {
            return;
        }
        ArrayList<String> expanded = new ArrayList<String>();
        ArrayList<String> selected = new ArrayList<String>();
        Object[] expandedElements = viewer.getVisibleExpandedElements();
        if (expandedElements.length > 0) {
            int i = 0;
            while (i < expandedElements.length) {
                if (expandedElements[i] instanceof IResource) {
                    expanded.add(((IResource)expandedElements[i]).getFullPath().toString());
                }
                ++i;
            }
        }
        if ((selectedElements = ((IStructuredSelection)viewer.getSelection()).toArray()).length > 0) {
            int i = 0;
            while (i < selectedElements.length) {
                if (selectedElements[i] instanceof IResource) {
                    selected.add(((IResource)selectedElements[i]).getFullPath().toString());
                }
                ++i;
            }
        }
        this.projectExpansions.put(project, expanded);
        this.projectSelections.put(project, selected);
        IResource filter = this.getFilterResource();
        if (filter != null) {
            this.projectFilters.put(project, filter.getLocation().toPortableString());
        } else {
            this.projectFilters.remove(project);
        }
    }

    private void addFocusHover() {
        int IMAGE_MARGIN = 2;
        Tree tree = this.getCommonViewer().getTree();
        tree.addListener(40, this.createHoverBGColorer());
        tree.addListener(9, this.createEyeballPainter(this.eyeball, 2, tree));
        this.getCommonViewer().getControl().addMouseMoveListener(this.createHoverTracker());
        this.getCommonViewer().getControl().addMouseTrackListener((MouseTrackListener)this.createTreeExitHoverRemover());
        this.getCommonViewer().getTree().addMouseListener(this.createEyeballFocusClickHandler(this.eyeball));
    }

    protected MouseListener createEyeballFocusClickHandler(final Image eyeball) {
        return new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                IResource text;
                if (FilteringProjectView.this.hoveredItem == null) {
                    return;
                }
                Tree tree = (Tree)e.widget;
                TreeItem t = tree.getItem(new Point(e.x, e.y));
                if (t == null) {
                    return;
                }
                if (!t.equals(FilteringProjectView.this.hoveredItem)) {
                    return;
                }
                if (e.x >= FilteringProjectView.this.lastDrawnX && e.x <= FilteringProjectView.this.lastDrawnX + eyeball.getBounds().width && (text = FilteringProjectView.this.getResourceToFilterBy()) != null) {
                    FilteringProjectView.this.fExpandedElements = FilteringProjectView.this.getCommonViewer().getExpandedElements();
                    FilteringProjectView.this.hoveredItem = null;
                    FilteringProjectView.this.setFilter(text);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        };
    }

    protected MouseTrackAdapter createTreeExitHoverRemover() {
        return new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                super.mouseExit(e);
                if (FilteringProjectView.this.hoveredItem == null) {
                    return;
                }
                FilteringProjectView.this.removeHoveredItem();
            }
        };
    }

    protected MouseMoveListener createHoverTracker() {
        return new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (FilteringProjectView.this.filterOn()) {
                    return;
                }
                TreeItem t = FilteringProjectView.this.getCommonViewer().getTree().getItem(new Point(e.x, e.y));
                if (FilteringProjectView.this.hoveredItem != null && FilteringProjectView.this.hoveredItem.equals(t)) {
                    return;
                }
                FilteringProjectView.this.removeHoveredItem();
                if (t == null) {
                    return;
                }
                IResource data = FilteringProjectView.this.getResource(t);
                if (data != null && data.getType() == 1) {
                    FilteringProjectView.this.hoveredItem = t;
                    FilteringProjectView.this.hoveredItem.setBackground(FilteringProjectView.this.getHoverBackgroundColor());
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            if ((this).FilteringProjectView.this.hoveredItem == null || FilteringProjectView.this.getCommonViewer() == null || FilteringProjectView.this.getCommonViewer().getTree() == null || (this).FilteringProjectView.this.hoveredItem.getBounds() == null) {
                                return;
                            }
                            FilteringProjectView.this.getCommonViewer().getTree().redraw((this).FilteringProjectView.this.hoveredItem.getBounds().x, (this).FilteringProjectView.this.hoveredItem.getBounds().y, (this).FilteringProjectView.this.hoveredItem.getBounds().width, (this).FilteringProjectView.this.hoveredItem.getBounds().height, true);
                        }
                    });
                }
            }
        };
    }

    protected Listener createEyeballPainter(final Image eyeball, final int IMAGE_MARGIN, final Tree tree) {
        return new Listener(){

            public void handleEvent(Event event) {
                if (FilteringProjectView.this.hoveredItem == null || FilteringProjectView.this.hoveredItem.isDisposed()) {
                    return;
                }
                if (eyeball != null) {
                    int endOfClientAreaX = tree.getClientArea().width + tree.getClientArea().x;
                    int endOfItemX = FilteringProjectView.this.hoveredItem.getBounds().width + FilteringProjectView.this.hoveredItem.getBounds().x;
                    FilteringProjectView.this.lastDrawnX = Math.max(endOfClientAreaX, endOfItemX) - (IMAGE_MARGIN + eyeball.getBounds().width);
                    int itemHeight = tree.getItemHeight();
                    int imageHeight = eyeball.getBounds().height;
                    int y = FilteringProjectView.this.hoveredItem.getBounds().y + (itemHeight - imageHeight) / 2;
                    event.gc.drawImage(eyeball, FilteringProjectView.this.lastDrawnX, y);
                }
            }
        };
    }

    protected Listener createHoverBGColorer() {
        return new Listener(){

            public void handleEvent(Event event) {
                if ((event.detail & 8) != 0) {
                    TreeItem item = (TreeItem)event.item;
                    if (FilteringProjectView.this.hoveredItem == null || !FilteringProjectView.this.hoveredItem.equals(item)) {
                        return;
                    }
                    Tree tree = (Tree)event.widget;
                    int clientWidth = tree.getClientArea().width;
                    GC gc = event.gc;
                    Color oldBackground = gc.getBackground();
                    gc.setBackground(FilteringProjectView.this.getHoverBackgroundColor());
                    gc.fillRectangle(0, event.y, clientWidth, event.height);
                    gc.setBackground(oldBackground);
                    event.detail &= 0xFFFFFFF7;
                }
            }
        };
    }

    @Override
    protected void removeFilter() {
        this.clearFilter();
        super.removeFilter();
    }

    @Override
    public void saveState(IMemento memento) {
        super.saveState(memento);
        CommonViewer viewer = this.getCommonViewer();
        if (viewer == null) {
            if (this.memento != null) {
                memento.putMemento(this.memento);
            }
            return;
        }
        this.updateProjectMementoCache(this.selectedProject);
        TreeSet<IProject> projects = new TreeSet<IProject>(new Comparator<IProject>(){

            @Override
            public int compare(IProject o1, IProject o2) {
                return o1 == o2 ? 0 : o1.getName().compareTo(o2.getName());
            }
        });
        projects.addAll(this.projectExpansions.keySet());
        projects.addAll(this.projectSelections.keySet());
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        for (IProject project : projects) {
            String filter;
            List<String> selected;
            if (!project.isAccessible() || this.projectExpansions.get(project).isEmpty() && this.projectSelections.get(project).isEmpty() && this.projectFilters.get(project) == null) continue;
            IMemento projectMemento = memento.createChild(TAG_PROJECT);
            projectMemento.putString(KEY_NAME, project.getName());
            List<String> expanded = this.projectExpansions.get(project);
            if (!expanded.isEmpty()) {
                IMemento expansionMem = projectMemento.createChild(TAG_EXPANDED);
                for (String expandedPath : expanded) {
                    if (workspaceRoot.findMember(expandedPath) == null) continue;
                    IMemento elementMem = expansionMem.createChild(TAG_ELEMENT);
                    elementMem.putString(TAG_PATH, expandedPath);
                }
            }
            if (!(selected = this.projectSelections.get(project)).isEmpty()) {
                IMemento selectionMem = projectMemento.createChild(TAG_SELECTION);
                for (String selectedPath : selected) {
                    if (workspaceRoot.findMember(selectedPath) == null) continue;
                    IMemento elementMem = selectionMem.createChild(TAG_ELEMENT);
                    elementMem.putString(TAG_PATH, selectedPath);
                }
            }
            if ((filter = this.projectFilters.get(project)) == null) continue;
            IMemento filterMem = projectMemento.createChild("filter");
            filterMem.putString(TAG_PATH, filter);
        }
    }

    protected void restoreStateJob(final IProject project) {
        WorkbenchJob job = new WorkbenchJob("Restoring State"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                FilteringProjectView.this.restoreState(project);
                return Status.OK_STATUS;
            }
        };
        EclipseUtil.setSystemForJob((Job)job);
        job.schedule(this.getRefreshJobDelay() * 2L);
    }

    protected void restoreState(IProject project) {
        IResource element;
        ArrayList<IResource> elements;
        CommonViewer viewer = this.getCommonViewer();
        Control control = viewer.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        IWorkspaceRoot container = ResourcesPlugin.getWorkspace().getRoot();
        List<String> expansions = this.projectExpansions.get(project);
        List<String> selections = this.projectSelections.get(project);
        control.setRedraw(false);
        String filter = this.projectFilters.get(project);
        if (filter == null || filter.length() == 0) {
            if (this.currentFilter != null) {
                this.clearFilter();
            }
        } else {
            IFile filterResource = project.getWorkspace().getRoot().getFileForLocation(Path.fromPortableString((String)filter));
            this.setFilter((IResource)filterResource);
        }
        if (selections != null) {
            elements = new ArrayList<IResource>();
            for (String selectionPath : selections) {
                element = container.findMember(selectionPath);
                if (element == null) continue;
                elements.add(element);
            }
            viewer.setSelection((ISelection)new StructuredSelection(elements), true);
        }
        if (expansions != null) {
            elements = new ArrayList();
            for (String expansionPath : expansions) {
                element = container.findMember(expansionPath);
                if (element == null) continue;
                elements.add(element);
            }
            viewer.setExpandedElements(elements.toArray());
        }
        control.setRedraw(true);
    }

    @Override
    protected void projectChanged(IProject oldProject, IProject newProject) {
        this.updateProjectMementoCache(oldProject);
        super.projectChanged(oldProject, newProject);
        this.restoreStateJob(newProject);
    }

    @Override
    public void dispose() {
        this.removeResourceListener();
        super.dispose();
    }

    private void addResourceListener() {
        this.fResourceListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IResourceDelta[] children;
                if (FilteringProjectView.this.selectedProject == null || !FilteringProjectView.this.selectedProject.exists()) {
                    return;
                }
                IResourceDelta delta = event.getDelta();
                IResourceDelta[] iResourceDeltaArray = children = delta.getAffectedChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceDelta iResourceDelta = iResourceDeltaArray[n2];
                    IResource resource = iResourceDelta.getResource();
                    if (resource != null && resource.getProject().equals((Object)FilteringProjectView.this.selectedProject)) {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                if (FilteringProjectView.this.getCommonViewer() != null && FilteringProjectView.this.getCommonViewer().getTree() != null && !FilteringProjectView.this.getCommonViewer().getTree().isDisposed()) {
                                    FilteringProjectView.this.getCommonViewer().refresh();
                                }
                            }
                        });
                        return;
                    }
                    ++n2;
                }
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.fResourceListener, 1);
    }

    private void removeResourceListener() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.fResourceListener);
    }

    protected void clearFilter() {
        this.currentFilter = null;
        this.filterChanged();
    }

    protected void setFilter(IResource resource) {
        this.currentFilter = resource;
        this.filterChanged();
    }

    private void createRefreshJob() {
        this.refreshJob = this.doCreateRefreshJob();
        EclipseUtil.setSystemForJob((Job)this.refreshJob);
    }

    protected void filterChanged() {
        if (this.refreshJob != null) {
            this.refreshJob.cancel();
            this.refreshJob.schedule(this.getRefreshJobDelay());
        }
    }

    protected long getRefreshJobDelay() {
        return 100L;
    }

    protected WorkbenchJob doCreateRefreshJob() {
        return new WorkbenchJob("Refresh Filter"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (FilteringProjectView.this.getCommonViewer().getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                Control redrawFalseControl = FilteringProjectView.this.getCommonViewer().getControl();
                try {
                    redrawFalseControl.setRedraw(false);
                    FilteringProjectView.this.getCommonViewer().collapseAll();
                    IResource filterResource = FilteringProjectView.this.getFilterResource();
                    try {
                        if (filterResource == null) {
                            if (FilteringProjectView.this.patternFilter != null) {
                                FilteringProjectView.this.getCommonViewer().removeFilter((ViewerFilter)FilteringProjectView.this.patternFilter);
                                FilteringProjectView.this.patternFilter = null;
                            }
                        } else {
                            if (FilteringProjectView.this.patternFilter != null) {
                                FilteringProjectView.this.getCommonViewer().removeFilter((ViewerFilter)FilteringProjectView.this.patternFilter);
                            }
                            FilteringProjectView.this.patternFilter = FilteringProjectView.this.createPatternFilter(filterResource);
                            FilteringProjectView.this.showFilterLabel(FilteringProjectView.this.eyeball, NLS.bind((String)Messages.FilteringProjectView_LBL_FilteringFor, (Object[])new Object[]{FilteringProjectView.this.patternFilter.getPattern()}));
                            FilteringProjectView.this.getCommonViewer().addFilter((ViewerFilter)FilteringProjectView.this.patternFilter);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (filterResource != null) {
                        TreeItem[] items = FilteringProjectView.this.getCommonViewer().getTree().getItems();
                        int treeHeight = FilteringProjectView.this.getCommonViewer().getTree().getBounds().height;
                        int numVisibleItems = treeHeight / FilteringProjectView.this.getCommonViewer().getTree().getItemHeight();
                        long stopTime = 200L + System.currentTimeMillis();
                        boolean cancel = false;
                        if (items.length > 0 && this.recursiveExpand(items, monitor, stopTime, new int[]{numVisibleItems})) {
                            cancel = true;
                        }
                        if (cancel) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                    } else if (FilteringProjectView.this.fExpandedElements != null) {
                        FilteringProjectView.this.getCommonViewer().collapseAll();
                        FilteringProjectView.this.getCommonViewer().setExpandedElements(FilteringProjectView.this.fExpandedElements);
                        FilteringProjectView.this.fExpandedElements = null;
                    }
                }
                finally {
                    TreeItem[] items = FilteringProjectView.this.getCommonViewer().getTree().getItems();
                    if (items.length > 0 && FilteringProjectView.this.getCommonViewer().getTree().getSelectionCount() == 0) {
                        FilteringProjectView.this.getCommonViewer().getTree().setTopItem(items[0]);
                    }
                    redrawFalseControl.setRedraw(true);
                }
                return Status.OK_STATUS;
            }

            private boolean recursiveExpand(TreeItem[] items, IProgressMonitor monitor, long cancelTime, int[] numItemsLeft) {
                boolean canceled = false;
                int i = 0;
                while (!canceled && i < items.length) {
                    boolean visible;
                    TreeItem item = items[i];
                    int n = numItemsLeft[0];
                    numItemsLeft[0] = n - 1;
                    boolean bl = visible = n >= 0;
                    if (monitor.isCanceled() || !visible && System.currentTimeMillis() > cancelTime) {
                        canceled = true;
                    } else {
                        Object itemData = item.getData();
                        if (itemData != null) {
                            if (!item.getExpanded()) {
                                FilteringProjectView.this.getCommonViewer().setExpandedState(itemData, true);
                            }
                            TreeItem[] children = item.getItems();
                            if (items.length > 0) {
                                canceled = this.recursiveExpand(children, monitor, cancelTime, numItemsLeft);
                            }
                        }
                    }
                    ++i;
                }
                return canceled;
            }
        };
    }

    protected AbstractResourceBasedViewerFilter createPatternFilter(IResource filterResource) {
        AbstractResourceBasedViewerFilter patternFilter;
        if (this.fFilenameSearchMode && this.filterViaSearch) {
            this.filenameFilter.setResourceToFilterOn((IResource)this.selectedProject);
            this.filterViaSearch = false;
            return this.filenameFilter;
        }
        IProject project = filterResource.getProject();
        HashSet<String> natures = new HashSet<String>();
        try {
            String[] stringArray = project.getDescription().getNatureIds();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String natureId = stringArray[n2];
                natures.add(natureId);
                ++n2;
            }
        }
        catch (CoreException natureId) {
            // empty catch block
        }
        final ArrayList<AbstractResourceBasedViewerFilter> filters = new ArrayList<AbstractResourceBasedViewerFilter>();
        final ArrayList<Integer> priorities = new ArrayList<Integer>();
        for (IConfigurationElement element : this.getResourceBasedFilters()) {
            if (!natures.contains(element.getAttribute(ELEMENT_NATURE))) continue;
            try {
                Integer priority;
                AbstractResourceBasedViewerFilter participant = (AbstractResourceBasedViewerFilter)((Object)element.createExecutableExtension(ELEMENT_CLASS));
                String rawPriority = element.getAttribute(ELEMENT_PRIORITY);
                try {
                    priority = Integer.parseInt(rawPriority);
                }
                catch (NumberFormatException e) {
                    priority = 50;
                }
                filters.add(participant);
                priorities.add(priority);
            }
            catch (CoreException e) {
                ExplorerPlugin.logError(e);
            }
        }
        if (filters.isEmpty()) {
            patternFilter = new PathFilter();
        } else if (filters.size() > 1) {
            ArrayList copy = new ArrayList(filters);
            Collections.sort(copy, new Comparator<AbstractResourceBasedViewerFilter>(){

                @Override
                public int compare(AbstractResourceBasedViewerFilter arg0, AbstractResourceBasedViewerFilter arg1) {
                    return ((Integer)priorities.get(filters.indexOf((Object)arg0))).compareTo((Integer)priorities.get(filters.indexOf((Object)arg1)));
                }
            });
            patternFilter = (AbstractResourceBasedViewerFilter)((Object)copy.get(0));
        } else {
            patternFilter = (AbstractResourceBasedViewerFilter)((Object)filters.get(0));
        }
        ((AbstractResourceBasedViewerFilter)patternFilter).setResourceToFilterOn(filterResource);
        return patternFilter;
    }

    private synchronized Collection<IConfigurationElement> getResourceBasedFilters() {
        if (this.fgElements == null) {
            IExtensionPoint extensionPoint;
            this.fgElements = new ArrayList();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            if (registry != null && (extensionPoint = registry.getExtensionPoint("com.aptana.explorer", FILTERS_EXT_PT_ID)) != null) {
                IExtension[] iExtensionArray = extensionPoint.getExtensions();
                int n = iExtensionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension extension = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement element = iConfigurationElementArray[n4];
                        if ("filter".equals(element.getName())) {
                            this.fgElements.add(element);
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
        return this.fgElements;
    }

    protected IResource getFilterResource() {
        return this.currentFilter;
    }

    private IResource getResourceToFilterBy() {
        return this.getResource(this.hoveredItem);
    }

    private void removeHoveredItem() {
        if (this.hoveredItem == null) {
            return;
        }
        if (this.hoveredItem.isDisposed()) {
            this.hoveredItem = null;
            return;
        }
        final Rectangle bounds = this.hoveredItem.getBounds();
        this.hoveredItem.setBackground(null);
        this.hoveredItem = null;
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                FilteringProjectView.this.getCommonViewer().getTree().redraw(bounds.x, bounds.y, bounds.width, bounds.height, true);
            }
        });
    }

    protected Color getHoverBackgroundColor() {
        return UIUtils.getDisplay().getSystemColor(22);
    }

    private boolean filterOn() {
        return this.getFilterResource() != null;
    }

    protected IResource getResource(TreeItem t) {
        Object data = t.getData();
        if (data instanceof IResource) {
            return (IResource)t.getData();
        }
        if (data instanceof IAdaptable) {
            IAdaptable adapt = (IAdaptable)data;
            return (IResource)adapt.getAdapter(IResource.class);
        }
        return null;
    }

    @Override
    protected Composite createSearchComposite(Composite myComposite) {
        this.search = (SearchComposite)super.createSearchComposite(myComposite);
        final Menu modeMenu = new Menu((Control)this.search);
        MenuItem filenameItem = new MenuItem(modeMenu, 16);
        filenameItem.setText(Messages.FilteringProjectView_SearchByFilenameLabel);
        filenameItem.setSelection(this.fFilenameSearchMode);
        filenameItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilteringProjectView.this.fFilenameSearchMode = true;
            }
        });
        MenuItem contentItem = new MenuItem(modeMenu, 16);
        contentItem.setText(Messages.FilteringProjectView_SearchContentLabel);
        contentItem.setSelection(!this.fFilenameSearchMode);
        contentItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilteringProjectView.this.fFilenameSearchMode = false;
            }
        });
        this.search.getTextControl().addListener(9, new Listener(){

            public void handleEvent(Event event) {
                GC gc = event.gc;
                int width = 7;
                int x = 15;
                int y = 10;
                if (Platform.getOS().equals("win32")) {
                    x = event.width - 7;
                    y = 10;
                } else if (Platform.getOS().equals("linux")) {
                    if (PlatformUtil.isOSName((String)"Ubuntu")) {
                        x = 0;
                        y = 17;
                    } else {
                        x = 0;
                        y = 15;
                    }
                }
                Color bg = gc.getBackground();
                gc.setBackground(gc.getDevice().getSystemColor(33));
                gc.fillPolygon(new int[]{x, y, x + 7 - 1, y, x + 3, y + 3});
                gc.setBackground(bg);
            }
        });
        this.search.getTextControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                boolean isOnPulldownSection = false;
                int shift = 0;
                if (Platform.getOS().equals("win32")) {
                    Rectangle bounds = FilteringProjectView.this.search.getTextControl().getBounds();
                    if (e.x >= bounds.width - 20 && e.x <= bounds.width) {
                        isOnPulldownSection = true;
                        shift = bounds.width - 20;
                    }
                } else if (e.x <= 18) {
                    isOnPulldownSection = true;
                }
                if (isOnPulldownSection) {
                    Point searchLocation = FilteringProjectView.this.search.getLocation();
                    searchLocation = FilteringProjectView.this.search.getParent().toDisplay(searchLocation.x, searchLocation.y);
                    Point searchSize = FilteringProjectView.this.search.getSize();
                    modeMenu.setLocation(searchLocation.x + shift, searchLocation.y + searchSize.y + 2);
                    modeMenu.setVisible(true);
                }
            }
        });
        return this.search;
    }

    @Override
    public void search(final String text, boolean isCaseSensitive, boolean isRegularExpression) {
        if (this.selectedProject == null) {
            return;
        }
        if (this.fFilenameSearchMode) {
            this.clearFilter();
            try {
                final Pattern pattern = this.search.createSearchPattern();
                this.search.getTextControl().setForeground(this.search.getDisplay().getSystemColor(2));
                this.filenameFilter = new PathFilter(){

                    protected boolean match(String string) {
                        if (pattern == null) {
                            return false;
                        }
                        return pattern.matcher(string).find();
                    }

                    public String getPattern() {
                        return text;
                    }
                };
                this.filterViaSearch = true;
                this.setFilter((IResource)this.selectedProject);
            }
            catch (PatternSyntaxException e) {
                this.search.getTextControl().setForeground(this.search.getDisplay().getSystemColor(3));
            }
        } else {
            super.search(text, isCaseSensitive, isRegularExpression);
        }
    }
}

